/*
 * Decompiled with CFR 0.152.
 */
package lt.b1.cash.register.syncer;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.application.Application;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.util.Duration;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import lt.b1.cash.register.syncer.component.RegisterDB;
import lt.b1.cash.register.syncer.logger.Log;
import lt.b1.cash.register.syncer.logger.Logger;
import lt.b1.cash.register.syncer.model.Sale;
import lt.b1.cash.register.syncer.model.Settings;
import lt.b1.cash.register.syncer.service.B1SaleSyncService;
import lt.b1.cash.register.syncer.service.RegisterProductMonitorService;
import lt.b1.cash.register.syncer.service.RegisterSaleMonitorService;
import lt.b1.cash.register.syncer.task.RegisterConnectionTask;
import lt.b1.cash.register.syncer.task.RegisterProductDeleteTask;
import lt.b1.cash.register.syncer.task.RegisterProductSyncTask;
import lt.b1.cash.register.syncer.view.RootLayoutController;
import lt.b1.cash.register.syncer.view.SaleOverviewController;
import lt.b1.cash.register.syncer.view.SettingsDialogController;

public final class App
extends Application {
    public Stage primaryStage;
    public BooleanProperty monitor = new SimpleBooleanProperty(false);
    public BooleanProperty connectedToRegister = new SimpleBooleanProperty(false);
    private final Log log;
    private final Logger logger;
    private BorderPane rootLayout;
    private ObservableList<Sale> saleData = FXCollections.observableArrayList();
    private RegisterDB registerDb;
    private Settings settings;
    private ResourceBundle rb;
    private RegisterSaleMonitorService registerSaleMonitorService;
    private B1SaleSyncService b1SaleSyncService;
    private RegisterProductMonitorService registerProductMonitorService;

    public App() {
        this.log = new Log();
        this.logger = new Logger(this.log, "main");
    }

    public static void main(String[] args) {
        App.launch(args);
    }

    @Override
    public void start(Stage primaryStage) {
        this.loadSettingsFromFile();
        this.rb = ResourceBundle.getBundle("bundles.LangBundle", new Locale(this.settings.getLanguage(), this.settings.getLocale()));
        this.primaryStage = primaryStage;
        this.primaryStage.setTitle(this.rb.getString("title"));
        this.enforceSingleInstance();
        this.initRootLayout();
        this.showSaleOverview();
        if (this.settings.getConnectOnRun().booleanValue()) {
            this.startRegisterMonitor();
        }
    }

    @Override
    public void stop() {
        this.settings.setIsLocked(false);
        this.saveSettingsToFile();
    }

    public void enforceSingleInstance() {
    }

    public void initRootLayout() {
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setResources(this.rb);
            loader.setLocation(this.getClass().getResource("/fxml/RootLayout.fxml"));
            this.rootLayout = (BorderPane)loader.load();
            Scene scene = new Scene(this.rootLayout);
            this.primaryStage.setScene(scene);
            RootLayoutController controller = (RootLayoutController)loader.getController();
            controller.setMainApp(this);
            this.primaryStage.show();
        }
        catch (IOException ex) {
            this.logger.error(ex.getMessage(), ex.getStackTrace());
        }
    }

    public void showSaleOverview() {
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setResources(this.rb);
            loader.setLocation(this.getClass().getResource("/fxml/SaleOverview.fxml"));
            AnchorPane saleOverview = (AnchorPane)loader.load();
            this.rootLayout.setCenter(saleOverview);
            this.primaryStage.getScene().getStylesheets().add("/styles/log-view.css");
            SaleOverviewController controller = (SaleOverviewController)loader.getController();
            controller.setMainApp(this);
        }
        catch (IOException ex) {
            this.logger.error(ex.getMessage(), ex.getStackTrace());
        }
    }

    public boolean showSettingsDialog() {
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setResources(this.rb);
            loader.setLocation(this.getClass().getResource("/fxml/SettingsDialog.fxml"));
            AnchorPane page = (AnchorPane)loader.load();
            Stage dialogStage = new Stage();
            dialogStage.setTitle(this.rb.getString("settings"));
            dialogStage.initModality(Modality.WINDOW_MODAL);
            dialogStage.initOwner(this.primaryStage);
            dialogStage.setResizable(false);
            Scene scene = new Scene(page);
            dialogStage.setScene(scene);
            SettingsDialogController controller = (SettingsDialogController)loader.getController();
            controller.setDialogStage(dialogStage);
            controller.setSettings(this.settings);
            controller.setMainApp(this);
            dialogStage.showAndWait();
            return controller.isSaveClicked();
        }
        catch (IOException ex) {
            this.logger.error(ex.getMessage(), ex.getStackTrace());
            return false;
        }
    }

    public void startRegisterMonitor() {
        RegisterConnectionTask task = new RegisterConnectionTask(this.getSettings(), this.getResourceBundle(), this.getRegisterDb(), this.getLogger());
        task.stateProperty().addListener((observableValue, oldState, newState) -> {
            if (newState.equals((Object)Worker.State.RUNNING)) {
                this.logger.debug(this.rb.getString("connectingToRegisterDb"));
            } else if (newState.equals((Object)Worker.State.SUCCEEDED)) {
                this.logger.debug(this.rb.getString("connectedToRegisterDb"));
                this.getSaleData().clear();
                this.setRegisterDb((RegisterDB)task.getValue());
                if (this.registerProductMonitorService != null) {
                    this.b1SaleSyncService.cancel();
                }
                this.b1SaleSyncService = new B1SaleSyncService(this.getSaleData(), this.getSettings(), this.getResourceBundle(), this.getRegisterDb(), this.getLogger(), this);
                this.b1SaleSyncService.setPeriod(Duration.seconds(this.getSettings().getB1SyncInterval().intValue()));
                this.listenRegisterSaleSyncService(this.b1SaleSyncService);
                this.b1SaleSyncService.start();
                if (this.registerSaleMonitorService != null) {
                    this.registerSaleMonitorService.cancel();
                }
                this.registerSaleMonitorService = new RegisterSaleMonitorService(this.getSaleData(), this.getSettings(), this.getResourceBundle(), this.getRegisterDb(), this.getLogger());
                this.registerSaleMonitorService.setPeriod(Duration.seconds(this.getSettings().getRegisterSaleSyncInterval().intValue()));
                this.listenRegisterSaleMonitorService(this.registerSaleMonitorService);
                this.registerSaleMonitorService.start();
                if (this.registerProductMonitorService != null) {
                    this.registerProductMonitorService.cancel();
                }
                this.registerProductMonitorService = new RegisterProductMonitorService(this.getSettings(), this.getResourceBundle(), this.getRegisterDb(), this.getLogger());
                this.registerProductMonitorService.setPeriod(Duration.seconds(this.getSettings().getRegisterProductSyncInterval().intValue()));
                this.listenRegisterProductMonitorService(this.registerProductMonitorService);
                this.registerProductMonitorService.start();
                this.monitor.unbind();
                this.monitor.bind(Bindings.and(Bindings.and(this.b1SaleSyncService.stateProperty().isNotEqualTo((Object)Worker.State.FAILED).and(this.b1SaleSyncService.stateProperty().isNotEqualTo((Object)Worker.State.CANCELLED)), this.registerSaleMonitorService.stateProperty().isNotEqualTo((Object)Worker.State.FAILED).and(this.registerSaleMonitorService.stateProperty().isNotEqualTo((Object)Worker.State.CANCELLED))), this.registerProductMonitorService.stateProperty().isNotEqualTo((Object)Worker.State.FAILED).and(this.registerProductMonitorService.stateProperty().isNotEqualTo((Object)Worker.State.CANCELLED))));
                this.connectedToRegister.unbind();
                this.connectedToRegister.bind(this.getRegisterDb().connectedProperty());
            } else if (newState.equals((Object)Worker.State.FAILED)) {
                this.logger.error(this.rb.getString("unableToConnectToRegisterDb"));
            } else if (newState.equals((Object)Worker.State.CANCELLED)) {
                this.logger.error(this.rb.getString("connectionToRegisterDbIsCanceled"));
            }
        });
        Thread thread = new Thread(task);
        thread.setDaemon(true);
        thread.start();
    }

    public void stopRegisterMonitor() {
        this.b1SaleSyncService.cancel();
        this.registerSaleMonitorService.cancel();
        this.registerProductMonitorService.cancel();
        this.registerDb.closeDbConnection();
        this.getSaleData().clear();
    }

    private void listenRegisterSaleSyncService(B1SaleSyncService service) {
        service.stateProperty().addListener((observableValue, oldState, newState) -> {
            if (newState.equals((Object)Worker.State.FAILED)) {
                this.stopRegisterMonitor();
            }
        });
    }

    private void listenRegisterSaleMonitorService(RegisterSaleMonitorService service) {
        service.stateProperty().addListener((observableValue, oldState, newState) -> {
            if (newState.equals((Object)Worker.State.FAILED)) {
                this.stopRegisterMonitor();
            }
        });
    }

    private void listenRegisterProductMonitorService(RegisterProductMonitorService service) {
        service.stateProperty().addListener((observableValue, oldState, newState) -> {
            if (newState.equals((Object)Worker.State.FAILED)) {
                this.stopRegisterMonitor();
            }
        });
    }

    public void syncProducts() {
        RegisterProductSyncTask task = new RegisterProductSyncTask(this.getSettings(), this.getRegisterDb(), this.getResourceBundle(), this.getLogger());
        task.stateProperty().addListener((observableValue, oldState, newState) -> {
            if (newState.equals((Object)Worker.State.RUNNING)) {
                this.logger.debug(this.rb.getString("syncingProducts"));
            } else if (newState.equals((Object)Worker.State.SUCCEEDED)) {
                this.logger.info(this.rb.getString("finishedSyncingProducts"));
            } else if (newState.equals((Object)Worker.State.FAILED)) {
                this.logger.error(this.rb.getString("unableToSyncProducts"));
            }
        });
        Thread thread = new Thread(task);
        thread.setDaemon(true);
        thread.start();
    }

    public void deleteProducts() {
        RegisterProductDeleteTask task = new RegisterProductDeleteTask(this.getRegisterDb(), this.getLogger());
        task.stateProperty().addListener((observableValue, oldState, newState) -> {
            if (newState.equals((Object)Worker.State.RUNNING)) {
                this.logger.debug(this.rb.getString("deletingProducts"));
            } else if (newState.equals((Object)Worker.State.SUCCEEDED)) {
                this.logger.info(this.rb.getString("finishedDeletingProducts"));
            } else if (newState.equals((Object)Worker.State.FAILED)) {
                this.logger.error(this.rb.getString("unableToDeleteProducts"));
            }
        });
        Thread thread = new Thread(task);
        thread.setDaemon(true);
        thread.start();
    }

    public void loadSettingsFromFile() {
        try {
            File file = this.getSettingsFile();
            JAXBContext context = JAXBContext.newInstance(Settings.class);
            Unmarshaller um = context.createUnmarshaller();
            this.settings = (Settings)um.unmarshal(file);
        }
        catch (JAXBException ex) {
            this.settings = new Settings();
        }
    }

    public boolean saveSettingsToFile() {
        File file = this.getSettingsFile();
        try {
            JAXBContext context = JAXBContext.newInstance(Settings.class);
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", true);
            m.marshal((Object)this.settings, file);
            return true;
        }
        catch (JAXBException ex) {
            this.logger.error(ex.getMessage(), ex.getStackTrace());
            return false;
        }
    }

    public boolean resetSettings() {
        this.settings = new Settings();
        return this.saveSettingsToFile();
    }

    public File getSettingsFile() {
        File file = new File(this.getSettingsFilePath(), "settings.xml");
        try {
            file.createNewFile();
        }
        catch (IOException ex) {
            this.logger.error(ex.getMessage(), ex.getStackTrace());
        }
        return file;
    }

    public File getSettingsFilePath() {
        String fullPath = System.getProperty("user.home") + File.separator + ".b1syncer";
        File path = new File(fullPath);
        path.mkdir();
        return path;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public ResourceBundle getResourceBundle() {
        return this.rb;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public RegisterDB getRegisterDb() {
        return this.registerDb;
    }

    public void setRegisterDb(RegisterDB value) {
        this.registerDb = value;
    }

    public ObservableList<Sale> getSaleData() {
        return this.saleData;
    }

    public Stage getPrimaryStage() {
        return this.primaryStage;
    }
}

