/*
 * Decompiled with CFR 0.152.
 */
package lt.b1.cash.register.syncer.component;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.lang.reflect.Type;
import java.net.URI;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lt.b1.cash.register.syncer.component.B1ProductResponseDeserializer;
import lt.b1.cash.register.syncer.component.Utils;
import lt.b1.cash.register.syncer.logger.Logger;
import lt.b1.cash.register.syncer.model.B1ProductListResponse;
import lt.b1.cash.register.syncer.model.B1SaleAddResponse;
import lt.b1.cash.register.syncer.model.Product;
import lt.b1.cash.register.syncer.model.Sale;
import lt.b1.cash.register.syncer.model.SaleItem;
import lt.b1.cash.register.syncer.model.Settings;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class B1 {
    public static final String VERSION = "2.0.10";
    public static final String PLATFORM = "B1 Cash Register";
    public static final String ROWS_PER_PAGE = "500";
    public static final String SORT_DIRECTION = "asc";
    public static final String SORT_ATTRIBUTE = "id";
    private final String scheme;
    private final String baseApiUrl;
    private final String apiUri = "/api/";
    private final String apiKey;
    private final String privateKey;
    private final Logger logger;
    private String syncWithAttributes = "";

    public B1(Settings settings, Logger logger) {
        this.apiKey = settings.getB1ApiKey();
        this.privateKey = settings.getB1PrivateKey();
        this.scheme = settings.getB1Address().contains("https") ? "https" : "http";
        this.baseApiUrl = settings.getB1Address().replaceFirst("^(http://|https://)", "") + "/api/";
        this.syncWithAttributes = settings.getRegisterProductSyncWithAttributes();
        this.logger = logger;
    }

    public B1(String apiKey, String privateKey, String baseApiUrl, Logger logger) {
        this.apiKey = apiKey;
        this.privateKey = privateKey;
        this.scheme = baseApiUrl.contains("https") ? "https" : "http";
        this.baseApiUrl = baseApiUrl.replaceFirst("^(http://|https://)", "") + "/api/";
        this.logger = logger;
    }

    public B1ProductListResponse testConnectionProducts() {
        return this.fetchCashRegisterProducts(1);
    }

    public B1ProductListResponse fetchCashRegisterProducts(Integer pageId) {
        JsonObject parameters = this.buildFetchParamters(pageId);
        JsonObject result = this.makeRequestToApi("reference-book/items/list", parameters);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter((Type)((Object)Product.class), new B1ProductResponseDeserializer());
        Gson gson = builder.create();
        return gson.fromJson((JsonElement)result, B1ProductListResponse.class);
    }

    private JsonObject buildFetchParamters(Integer pageId) {
        JsonObject parameters = new JsonObject();
        parameters.addProperty("page", pageId.toString());
        parameters.addProperty("rows", ROWS_PER_PAGE);
        parameters.addProperty("sord", SORT_DIRECTION);
        parameters.addProperty("sidx", SORT_ATTRIBUTE);
        JsonObject filters = new JsonObject();
        filters.addProperty("groupOp", "AND");
        JsonArray rules = new JsonArray();
        if (this.syncWithAttributes.length() > 0) {
            List<String> list = Arrays.asList(this.syncWithAttributes.split(","));
            JsonArray data = new JsonArray();
            for (String item : list) {
                data.add(item);
            }
            JsonObject rule = new JsonObject();
            rule.addProperty("field", "attributeId");
            rule.addProperty("op", "in");
            rule.add("data", data);
            rules.add(rule);
        }
        filters.add("rules", rules);
        parameters.add("filters", filters);
        return parameters;
    }

    public B1SaleAddResponse sendSale(Sale sale, List<SaleItem> saleItems) {
        JsonObject parameters = new JsonObject();
        parameters.addProperty("receiptId", Utils.encodeString(sale.getReceiptId().toString()));
        parameters.addProperty("receiptNumber", Utils.encodeString(sale.getReceiptNumber()));
        parameters.addProperty("receiptDate", Utils.encodeString(sale.getReceiptDate().toString()));
        parameters.addProperty("customReceiptNumber", Utils.encodeString(sale.getCustomReceiptNumber()));
        parameters.addProperty("paidWithMoney", Utils.intToString(sale.getPaidWithMoney()));
        parameters.addProperty("paidWithOther", Utils.intToString(sale.getPaidWithOther()));
        parameters.addProperty("paidWithCard", Utils.intToString(sale.getPaidWithCard()));
        parameters.addProperty("total", Utils.intToString(sale.getTotal()));
        parameters.addProperty("vat", Utils.intToString(sale.getVat()));
        parameters.addProperty("discount", Utils.intToString(sale.getDiscount()));
        parameters.addProperty("loyaltyCardNumber", Utils.encodeString(sale.getLoyaltyCardNumber()));
        parameters.addProperty("cashRegisterNumber", Utils.encodeString(sale.getCashRegisterNumber()));
        parameters.addProperty("cashierFullName", Utils.encodeString(sale.getCashierFullName()));
        JsonArray items = new JsonArray();
        for (SaleItem saleItem : saleItems) {
            JsonObject item = new JsonObject();
            item.addProperty("name", Utils.encodeString(saleItem.getName()));
            item.addProperty("code", Utils.encodeString(saleItem.getCode()));
            item.addProperty("barcode", Utils.encodeString(saleItem.getBarcode()));
            item.addProperty("quantity", Utils.intToString(saleItem.getQuantity()));
            item.addProperty("price", Utils.intToString(saleItem.getPrice()));
            item.addProperty("discount", Utils.intToString(saleItem.getDiscount()));
            item.addProperty("discountRate", Utils.deflateToString(saleItem.getDiscountRate()));
            item.addProperty("vat", Utils.intToString(saleItem.getVat()));
            item.addProperty("vatRate", Utils.deflateToString(saleItem.getVatRate()));
            item.addProperty("total", Utils.intToString(saleItem.getTotal()));
            items.add(item);
        }
        parameters.add("items", items);
        JsonObject result = this.makeRequestToApi("register/sale/add", parameters);
        Gson gson = new GsonBuilder().create();
        return gson.fromJson((JsonElement)result, B1SaleAddResponse.class);
    }

    private JsonObject makeRequestToApi(String path, JsonObject data) {
        try {
            CloseableHttpClient client = HttpClients.createDefault();
            URI uri = new URIBuilder().setScheme(this.scheme).setHost(this.baseApiUrl).setPath(path).build();
            HttpPost http = new HttpPost(uri);
            http.setEntity(new StringEntity(data.toString()));
            http.setHeader("B1-Api-Key", this.apiKey);
            http.setHeader("B1-Signature-Version", "2");
            http.setHeader("B1-Time", String.valueOf(Instant.now().getEpochSecond()));
            http.setHeader("B1-Version", VERSION);
            http.setHeader("Platform", PLATFORM);
            http.setHeader("Content-Type", "application/json");
            http.setHeader("B1-Signature", this.signRequest(http));
            CloseableHttpResponse response = client.execute(http);
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                throw new ClientProtocolException("Response contains no content");
            }
            String result = EntityUtils.toString(entity);
            this.logger.debug(result, "b1");
            client.close();
            JsonParser parser = new JsonParser();
            return (JsonObject)parser.parse(result);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), ex.getStackTrace(), "b1");
            return null;
        }
    }

    private String signRequest(HttpPost http) throws Exception {
        Object dataToSign = "";
        for (Header header : http.getAllHeaders()) {
            if (header.getName().equals("Content-Type")) {
                dataToSign = (String)dataToSign + "Content-Length".toLowerCase() + Long.toString(http.getEntity().getContentLength());
            }
            dataToSign = (String)dataToSign + header.getName().toLowerCase() + header.getValue();
        }
        dataToSign = (String)dataToSign + EntityUtils.toString(http.getEntity(), "UTF-8");
        SecretKeySpec secretKey = new SecretKeySpec(this.privateKey.getBytes("UTF-8"), "HmacSHA512");
        Mac mac = Mac.getInstance("HmacSHA512");
        mac.init(secretKey);
        byte[] macData = mac.doFinal(((String)dataToSign).getBytes("UTF-8"));
        byte[] hex = new Hex().encode(macData);
        return new String(hex, "ISO-8859-1");
    }
}

