/*
 * Decompiled with CFR 0.152.
 */
package lt.b1.cash.register.syncer.component;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import lt.b1.cash.register.syncer.component.Utils;
import lt.b1.cash.register.syncer.model.Product;

public class B1ProductResponseDeserializer
implements JsonDeserializer<Product> {
    @Override
    public Product deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject p = json.getAsJsonObject();
        return new Product(this.getInt(p, "id"), this.getString(p, "code"), this.getString(p, "barcode"), this.getString(p, "name"), this.getNumeric(p, "priceWithVat"), this.getInt(p, "vatRate"), this.getInt(p, "freePrice"), this.getInt(p, "measurementUnitCanBeWeighed"), this.getInt(p, "groupId"), this.getString(p, "groupName"), this.getBoolean(p, "isActive"));
    }

    private Integer getInt(JsonObject object, String name) {
        Integer value;
        try {
            value = object.get(name).getAsInt();
        }
        catch (Exception ex) {
            value = null;
        }
        return value;
    }

    private Integer getNumeric(JsonObject object, String name) {
        Integer value;
        try {
            value = Utils.numericToInt(object.get(name).getAsString());
        }
        catch (Exception ex) {
            value = null;
        }
        return value;
    }

    private String getString(JsonObject object, String name) {
        String value;
        try {
            value = object.get(name).getAsString();
        }
        catch (Exception ex) {
            value = null;
        }
        return value;
    }

    private Boolean getBoolean(JsonObject object, String name) {
        Boolean value;
        try {
            value = object.get(name).getAsBoolean();
        }
        catch (Exception ex) {
            value = null;
        }
        return value;
    }
}

