/*
 * Decompiled with CFR 0.152.
 */
package lt.b1.cash.register.syncer.component;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import lt.b1.cash.register.syncer.component.DbUtils;
import lt.b1.cash.register.syncer.component.Utils;
import lt.b1.cash.register.syncer.logger.Logger;
import lt.b1.cash.register.syncer.model.Product;
import lt.b1.cash.register.syncer.model.Sale;
import lt.b1.cash.register.syncer.model.SaleItem;
import lt.b1.cash.register.syncer.model.Settings;

public class RegisterDB {
    private final Connection connection;
    private final ResourceBundle rb;
    private final Logger logger;
    private final String dbAddress;
    private final Integer dbPort;
    private final String dbName;
    private final String dbUser;
    private final String dbPassword;
    private final Map vatMap;
    private BooleanProperty connected = new SimpleBooleanProperty(false);

    public RegisterDB(Settings settings, ResourceBundle rb, Logger logger) throws Exception {
        try {
            this.rb = rb;
            this.logger = logger;
            this.dbAddress = settings.getRegisterDbAddress();
            this.dbPort = settings.getRegisterDbPort();
            this.dbName = settings.getRegisterDbName();
            this.dbUser = settings.getRegisterDbUser();
            this.dbPassword = settings.getRegisterDbPassword();
            this.vatMap = settings.getRegisterVatMap();
            this.connection = DriverManager.getConnection("jdbc:postgresql://" + this.dbAddress + ":" + this.dbPort + "/" + this.dbName, this.dbUser, this.dbPassword);
            this.connection.setAutoCommit(true);
            this.connection.setReadOnly(false);
            this.connected.set(true);
        }
        catch (SQLException ex) {
            logger.error(ex.getMessage(), ex.getStackTrace());
            throw ex;
        }
    }

    public BooleanProperty connectedProperty() {
        return this.connected;
    }

    public void closeDbConnection() {
        DbUtils.closeQuietly(this.connection);
    }

    public List<Sale> getSales(LocalDateTime latestSaleDateTime) {
        ArrayList<Sale> list = new ArrayList<Sale>();
        try {
            String sql = "select cast(s.docid as integer) as cekio_id, s.docid AS kap_cekionr, s.BON AS kap_kvito_nr, s.ecrid as kap_kasos_aparatas, s.operno AS kap_kasinininkas, to_date(s.date, 'YYYYMMDD') as kap_data, s.grynais as kap_apmoketa_grynais, coalesce(s.cekiais,0)+coalesce(s.kreditas,0)+ coalesce(s.pay1,0)+ coalesce(s.pay2,0)+ coalesce(s.pay3,0)+ coalesce(s.pay4,0) as kap_apmoketa_kitaip, coalesce(s.kortele,0) as kap_apmoketa_kortele, s.bontotal as kap_kvito_suma, s.lojuser as kap_lojalumo_kortele, sum(s.pvm) as kap_pvm_suma, sum(s.nadbotst) as kap_kvito_nuolaida, max(to_timestamp(s.date||' '||s.\"time\",'YYYYMMDD HH24:MI:SS')) as date_time from sales s where (to_timestamp(s.date||' '||s.\"time\",'YYYYMMDD HH24:MI:SS') < (CURRENT_TIMESTAMP+ interval' 1 minute')) and to_timestamp(s.date||' '||s.\"time\",'YYYYMMDD HH24:MI:SS') > ? group by 1,2,3,4,5,6,7,8,9,10,11 order by 1";
            PreparedStatement pstmnt = this.connection.prepareStatement(sql);
            pstmnt.setTimestamp(1, Timestamp.valueOf(latestSaleDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))));
            ResultSet rs = pstmnt.executeQuery();
            while (rs.next()) {
                list.add(new Sale(rs.getInt("cekio_id"), rs.getString("kap_cekionr"), rs.getString("kap_kvito_nr"), rs.getString("kap_data"), Utils.numericToInt(rs.getString("kap_apmoketa_grynais")), Utils.numericToInt(rs.getString("kap_apmoketa_kitaip")), Utils.numericToInt(rs.getString("kap_apmoketa_kortele")), Utils.numericToInt(rs.getString("kap_kvito_suma")), Utils.numericToInt(rs.getString("kap_pvm_suma")), Utils.numericToInt(rs.getString("kap_kvito_nuolaida")), rs.getString("kap_lojalumo_kortele"), rs.getString("kap_kasos_aparatas"), rs.getString("kap_kasinininkas"), rs.getString("date_time").substring(0, 19)));
            }
            pstmnt.close();
        }
        catch (SQLException ex) {
            this.logger.error(ex.getMessage(), ex.getStackTrace(), "b1");
        }
        return list;
    }

    public List<SaleItem> getSaleItems(Sale sale) {
        ArrayList<SaleItem> list = new ArrayList<SaleItem>();
        try {
            String sql = "select s.pluime as kapd_prekes_pav, s.plu as kapd_prekes_kodas, s.plubar as kapd_prekes_barcodas, s.qty as kapd_kiekis, trunc(s.plucena + s.nadbotst / qty, 2) as kapd_kaina, s.nadbotst as kapd_nuolaida, s.nuolproc as kapd_nuolaida_proc, s.vat_proc as kapd_pvm_tarifas, s.pvm as kapd_pvm_suma, trunc(s.total + s.nadbotst, 2) as kapd_suma from sales s where (cast(s.docid as integer) = ?) and to_date(s.date, 'YYYYMMDD') = ?";
            PreparedStatement pstmnt = this.connection.prepareStatement(sql);
            pstmnt.setInt(1, sale.getReceiptId());
            pstmnt.setDate(2, Date.valueOf(sale.getReceiptDate()));
            ResultSet rs = pstmnt.executeQuery();
            while (rs.next()) {
                list.add(new SaleItem(rs.getString("kapd_prekes_pav"), rs.getString("kapd_prekes_kodas"), rs.getString("kapd_prekes_barcodas"), Utils.numericToInt(rs.getString("kapd_kiekis")), Utils.numericToInt(rs.getString("kapd_kaina")), Utils.numericToInt(rs.getString("kapd_nuolaida")), Utils.numericToInt(rs.getString("kapd_nuolaida_proc")), Utils.numericToInt(rs.getString("kapd_pvm_suma")), Utils.numericToInt(rs.getString("kapd_pvm_tarifas")), Utils.numericToInt(rs.getString("kapd_suma"))));
            }
            pstmnt.close();
        }
        catch (SQLException ex) {
            this.logger.error(ex.getMessage(), ex.getStackTrace(), "b1");
        }
        return list;
    }

    public Boolean upsertProduct(Product product) {
        if (product.isActive.booleanValue() && product.groupId != null && product.groupId > 0) {
            try {
                String sql = "SELECT id FROM plu WHERE id=?";
                PreparedStatement pstmnt = this.connection.prepareStatement(sql);
                pstmnt.setInt(1, product.id);
                ResultSet rs = pstmnt.executeQuery();
                Boolean result = rs.next() ? this.updateProduct(product) : this.addProduct(product);
                pstmnt.close();
                return result;
            }
            catch (SQLException ex) {
                this.logger.error(ex.getMessage(), ex.getStackTrace(), "b1");
                return false;
            }
        }
        return false;
    }

    public Boolean updateProduct(Product product) {
        try {
            String sql = "UPDATE plu SET pluime = ?, plucod = ?, plubar = ?, cena = ?, vat = ?, cialoqty = ?, grp = ?, grpname = ?, freeprc = ? WHERE id = ?";
            PreparedStatement pstmnt = this.connection.prepareStatement(sql);
            DbUtils.setValues(pstmnt, Utils.trim(product.name, 100), product.code, product.barcode, Utils.intToNumeric(product.priceWithVat), Utils.convertVat(product.vatRate, this.vatMap), Utils.convertCanBeWeighed(product.measurementUnitCanBeWeighed), product.groupId, Utils.trim(product.groupName, 50), product.freePrice, product.id);
            pstmnt.executeUpdate();
            return true;
        }
        catch (SQLException ex) {
            this.logger.error(ex.getMessage(), ex.getStackTrace(), "b1");
            return false;
        }
    }

    public Boolean addProduct(Product product) {
        try {
            String sql = "insert into plu (id, pluime, plucod, plubar, cena, vat, cialoqty, grp, grpname, freeprc) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            PreparedStatement pstmnt = this.connection.prepareStatement(sql);
            DbUtils.setValues(pstmnt, product.id, Utils.trim(product.name, 100), product.code, product.barcode, Utils.intToNumeric(product.priceWithVat), Utils.convertVat(product.vatRate, this.vatMap), Utils.convertCanBeWeighed(product.measurementUnitCanBeWeighed), product.groupId, Utils.trim(product.groupName, 50), product.freePrice);
            pstmnt.executeUpdate();
            return true;
        }
        catch (SQLException ex) {
            this.logger.error(ex.getMessage(), ex.getStackTrace(), "b1");
            return false;
        }
    }

    public Boolean deleteProducts() {
        try {
            this.logger.debug(this.rb.getString("deletingProductsFromRegisterDb"));
            String sql = "delete from plu";
            PreparedStatement pstmnt = this.connection.prepareStatement(sql);
            pstmnt.executeUpdate();
            return true;
        }
        catch (SQLException ex) {
            this.logger.error(ex.getMessage(), ex.getStackTrace(), "b1");
            return false;
        }
    }
}

