/*
 * Decompiled with CFR 0.152.
 */
package lt.b1.cash.register.syncer.component;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.Map;

public class Utils {
    public static String encodeString(String value) {
        if (value == null) {
            return "";
        }
        try {
            return URLEncoder.encode(value.trim(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return value;
        }
    }

    public static String trim(String value, Integer length) {
        if (value == null) {
            return null;
        }
        if (value.length() > length) {
            return value.substring(0, length);
        }
        return value;
    }

    public static String deflateToString(Integer value) {
        value = Utils.intToNumeric(value).intValue();
        return value.toString();
    }

    public static Integer numericToInt(Double value) {
        if (value == null) {
            return null;
        }
        DecimalFormat formatter = new DecimalFormat("#0.00");
        BigDecimal amount = new BigDecimal(value);
        String result = formatter.format(amount).replaceAll("[^0-9-]+", "");
        if (result.trim().equals("")) {
            return null;
        }
        return Integer.valueOf(result);
    }

    public static Integer numericToInt(String value) {
        if ((value = value.trim()) == null || value.equals("")) {
            return null;
        }
        DecimalFormat formatter = new DecimalFormat("#0.00");
        BigDecimal amount = new BigDecimal(value);
        Object result = formatter.format(amount).replaceAll("[^0-9-]+", "");
        if (((String)result).trim().equals("")) {
            return null;
        }
        if (value.charAt(0) == '-' && ((String)result).charAt(0) != '-') {
            result = "-" + (String)result;
        }
        return Integer.valueOf((String)result);
    }

    public static String intToString(Integer value) {
        return value.toString();
    }

    public static Double intToNumeric(Integer value) {
        if (value == null) {
            return null;
        }
        return (double)value.intValue() / 100.0;
    }

    public static Integer convertVat(Integer vat, Map<Integer, Integer> map) {
        Integer value = map.get(vat);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public static Integer convertCanBeWeighed(Integer measurementUnitCanBeWeighed) {
        if (measurementUnitCanBeWeighed == null) {
            return 0;
        }
        if (measurementUnitCanBeWeighed == 1) {
            return 1;
        }
        return 0;
    }
}

