/*
 * Decompiled with CFR 0.152.
 */
package lt.b1.cash.register.syncer.logger;

import java.util.logging.Level;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Duration;
import lt.b1.cash.register.syncer.logger.LogRecord;
import lt.b1.cash.register.syncer.logger.Logger;

public class LogView
extends ListView<LogRecord> {
    private static final int MAX_ENTRIES = 10000;
    private static final PseudoClass debug = PseudoClass.getPseudoClass("debug");
    private static final PseudoClass info = PseudoClass.getPseudoClass("info");
    private static final PseudoClass warning = PseudoClass.getPseudoClass("warning");
    private static final PseudoClass error = PseudoClass.getPseudoClass("error");
    private final BooleanProperty follow = new SimpleBooleanProperty(true);
    private final ObservableList<LogRecord> logItems = FXCollections.observableArrayList();

    public BooleanProperty followProperty() {
        return this.follow;
    }

    public LogView(Logger logger, ListView listView) {
        Timeline logTransfer = new Timeline(new KeyFrame(Duration.seconds(1.0), event -> {
            logger.getLog().drainTo(this.logItems);
            if (this.logItems.size() > 10000) {
                this.logItems.remove(0, this.logItems.size() - 10000);
            }
            if (this.follow.get()) {
                listView.scrollTo(this.logItems.size());
            }
        }, new KeyValue[0]));
        logTransfer.setCycleCount(-1);
        logTransfer.play();
        listView.setCellFactory(param -> new ListCell<LogRecord>(){

            @Override
            protected void updateItem(LogRecord item, boolean empty) {
                super.updateItem(item, empty);
                this.pseudoClassStateChanged(debug, false);
                this.pseudoClassStateChanged(info, false);
                this.pseudoClassStateChanged(warning, false);
                this.pseudoClassStateChanged(error, false);
                if (item == null || empty) {
                    this.setText(null);
                    return;
                }
                this.setText(item.toString());
                if (item.getLevel() == Level.FINE) {
                    this.pseudoClassStateChanged(debug, true);
                } else if (item.getLevel() == Level.INFO) {
                    this.pseudoClassStateChanged(info, true);
                } else if (item.getLevel() == Level.WARNING) {
                    this.pseudoClassStateChanged(warning, true);
                } else if (item.getLevel() == Level.SEVERE) {
                    this.pseudoClassStateChanged(error, true);
                }
            }
        });
        listView.setItems(this.logItems);
    }
}

