/*
 * Decompiled with CFR 0.152.
 */
package lt.b1.cash.register.syncer.logger;

import java.util.Arrays;
import java.util.logging.Level;
import lt.b1.cash.register.syncer.logger.Log;
import lt.b1.cash.register.syncer.logger.LogRecord;

public class Logger {
    private final Log log;
    private final String context;

    public Logger(Log log, String context) {
        this.log = log;
        this.context = context;
    }

    public void log(LogRecord record) {
        this.log.offer(record);
    }

    public void debug(String msg) {
        this.log(new LogRecord(Level.FINE, this.context, msg));
    }

    public void debug(String msg, String context) {
        this.log(new LogRecord(Level.FINE, context, msg));
    }

    public void info(String msg) {
        this.log(new LogRecord(Level.INFO, this.context, msg));
    }

    public void info(String msg, String context) {
        this.log(new LogRecord(Level.INFO, context, msg));
    }

    public void warning(String msg) {
        this.log(new LogRecord(Level.WARNING, this.context, msg));
    }

    public void warning(String msg, String context) {
        this.log(new LogRecord(Level.WARNING, context, msg));
    }

    public void error(String msg) {
        this.log(new LogRecord(Level.SEVERE, this.context, msg));
    }

    public void error(String msg, String context) {
        this.log(new LogRecord(Level.SEVERE, context, msg));
    }

    public void error(String msg, StackTraceElement[] stackTrace) {
        this.log(new LogRecord(Level.SEVERE, this.context, msg + " : " + Arrays.toString(stackTrace)));
    }

    public void error(String msg, StackTraceElement[] stackTrace, String context) {
        this.log(new LogRecord(Level.SEVERE, context, msg + " : " + Arrays.toString(stackTrace)));
    }

    public Log getLog() {
        return this.log;
    }
}

