/*
 * Decompiled with CFR 0.152.
 */
package lt.b1.cash.register.syncer.service;

import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.concurrent.ScheduledService;
import javafx.concurrent.Task;
import lt.b1.cash.register.syncer.App;
import lt.b1.cash.register.syncer.component.RegisterDB;
import lt.b1.cash.register.syncer.logger.Logger;
import lt.b1.cash.register.syncer.model.Sale;
import lt.b1.cash.register.syncer.model.Settings;
import lt.b1.cash.register.syncer.task.B1SaleSyncTask;

public class B1SaleSyncService
extends ScheduledService<Void> {
    private final ObservableList<Sale> saleData;
    private final Settings settings;
    private final ResourceBundle rb;
    private final RegisterDB registerDb;
    private final Logger logger;
    private final App app;

    public B1SaleSyncService(ObservableList<Sale> saleData, Settings settings, ResourceBundle rb, RegisterDB registerDb, Logger logger, App app) {
        this.saleData = saleData;
        this.settings = settings;
        this.rb = rb;
        this.registerDb = registerDb;
        this.logger = logger;
        this.app = app;
        this.logger.info(rb.getString("b1SaleSync") + "+");
    }

    @Override
    protected void cancelled() {
        this.logger.error(this.rb.getString("b1SaleSync") + "STOP");
    }

    @Override
    protected void failed() {
        this.logger.error(this.rb.getString("b1SaleSync") + "-");
    }

    @Override
    protected Task<Void> createTask() {
        return new B1SaleSyncTask(this.saleData, this.settings, this.registerDb, this.logger, this.app);
    }
}

