/*
 * Decompiled with CFR 0.152.
 */
package lt.b1.cash.register.syncer.service;

import java.util.ResourceBundle;
import javafx.concurrent.ScheduledService;
import javafx.concurrent.Task;
import lt.b1.cash.register.syncer.component.RegisterDB;
import lt.b1.cash.register.syncer.logger.Logger;
import lt.b1.cash.register.syncer.model.Settings;
import lt.b1.cash.register.syncer.task.RegisterProductSyncTask;

public class RegisterProductMonitorService
extends ScheduledService<Void> {
    private final Settings settings;
    private final ResourceBundle rb;
    private final RegisterDB registerDb;
    private final Logger logger;

    public RegisterProductMonitorService(Settings settings, ResourceBundle rb, RegisterDB registerDb, Logger logger) {
        this.settings = settings;
        this.rb = rb;
        this.registerDb = registerDb;
        this.logger = logger;
        this.logger.info(rb.getString("registerProductMonitor") + "+");
    }

    @Override
    protected void cancelled() {
        this.logger.warning(this.rb.getString("registerProductMonitor") + "STOP");
    }

    @Override
    protected void failed() {
        this.logger.error(this.rb.getString("registerProductMonitor") + "-");
    }

    @Override
    protected Task<Void> createTask() {
        this.logger.debug(this.rb.getString("syncingProductsWithB1"));
        return new RegisterProductSyncTask(this.settings, this.registerDb, this.rb, this.logger);
    }
}

