/*
 * Decompiled with CFR 0.152.
 */
package lt.b1.cash.register.syncer.service;

import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.concurrent.ScheduledService;
import javafx.concurrent.Task;
import lt.b1.cash.register.syncer.component.RegisterDB;
import lt.b1.cash.register.syncer.logger.Logger;
import lt.b1.cash.register.syncer.model.Sale;
import lt.b1.cash.register.syncer.model.Settings;
import lt.b1.cash.register.syncer.task.RegisterSaleSyncTask;

public class RegisterSaleMonitorService
extends ScheduledService<String> {
    private final ObservableList<Sale> saleData;
    private final Settings settings;
    private final ResourceBundle rb;
    private final RegisterDB registerDb;
    private final Logger logger;
    private String latestSyncSaleDateTime = "1990-01-01 00:00:00";

    public RegisterSaleMonitorService(ObservableList<Sale> saleData, Settings settings, ResourceBundle rb, RegisterDB registerDb, Logger logger) {
        this.saleData = saleData;
        this.settings = settings;
        this.rb = rb;
        this.registerDb = registerDb;
        this.logger = logger;
        this.latestSyncSaleDateTime = settings.getRegisterLatestSyncSaleDateTime();
        this.logger.info(rb.getString("registerSaleMonitor") + "+");
    }

    @Override
    protected void cancelled() {
        this.latestSyncSaleDateTime = (String)this.getValue();
        this.logger.warning(this.rb.getString("registerSaleMonitor") + "STOP");
        super.cancelled();
    }

    @Override
    protected void failed() {
        this.logger.error(this.rb.getString("registerSaleMonitor") + "-");
        super.failed();
    }

    @Override
    protected void succeeded() {
        if (this.getValue() != null) {
            this.latestSyncSaleDateTime = (String)this.getValue();
        }
        super.succeeded();
    }

    @Override
    protected Task<String> createTask() {
        return new RegisterSaleSyncTask(this.saleData, this.registerDb, this.latestSyncSaleDateTime, this.logger);
    }
}

