/*
 * Decompiled with CFR 0.152.
 */
package lt.b1.cash.register.syncer.task;

import java.util.Iterator;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import lt.b1.cash.register.syncer.App;
import lt.b1.cash.register.syncer.component.B1;
import lt.b1.cash.register.syncer.component.RegisterDB;
import lt.b1.cash.register.syncer.logger.Logger;
import lt.b1.cash.register.syncer.model.B1SaleAddResponse;
import lt.b1.cash.register.syncer.model.Sale;
import lt.b1.cash.register.syncer.model.SaleItem;
import lt.b1.cash.register.syncer.model.Settings;

public class B1SaleSyncTask
extends Task {
    private final Settings settings;
    private final Logger logger;
    private final App app;
    private final RegisterDB registerDb;
    private final ObservableList<Sale> saleData;
    private List<Sale> list;

    public B1SaleSyncTask(ObservableList<Sale> saleData, Settings settings, RegisterDB registerDb, Logger logger, App app) {
        this.saleData = saleData;
        this.settings = settings;
        this.logger = logger;
        this.app = app;
        this.registerDb = registerDb;
    }

    public Void call() {
        try {
            if (!this.saleData.isEmpty()) {
                this.logger.debug(this.app.getResourceBundle().getString("sendingSalesToB1"));
                Iterator iterator = this.saleData.iterator();
                while (iterator.hasNext()) {
                    Sale sale = (Sale)iterator.next();
                    List<SaleItem> saleItems = this.registerDb.getSaleItems(sale);
                    B1 b1 = new B1(this.settings, this.logger);
                    B1SaleAddResponse response = b1.sendSale(sale, saleItems);
                    if (response.code == 200 || response.code == 409) {
                        this.settings.setRegisterLatestSyncSaleDateTime(sale.getDateTime());
                        this.app.saveSettingsToFile();
                        iterator.remove();
                        continue;
                    }
                    return null;
                }
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), ex.getStackTrace());
        }
        return null;
    }
}

