/*
 * Decompiled with CFR 0.152.
 */
package lt.b1.cash.register.syncer.task;

import java.util.ResourceBundle;
import javafx.concurrent.Task;
import lt.b1.cash.register.syncer.component.B1;
import lt.b1.cash.register.syncer.component.RegisterDB;
import lt.b1.cash.register.syncer.logger.Logger;
import lt.b1.cash.register.syncer.model.B1ProductListResponse;
import lt.b1.cash.register.syncer.model.Product;
import lt.b1.cash.register.syncer.model.Settings;

public class RegisterProductSyncTask
extends Task {
    private static final int MAX_REQUESTS_PER_ITERATION = 1000;
    private final Settings settings;
    private final ResourceBundle rb;
    private final RegisterDB registerDb;
    private final Logger logger;
    private Integer requestCount = 0;
    private Integer pageId = 1;

    public RegisterProductSyncTask(Settings settings, RegisterDB registerDb, ResourceBundle rb, Logger logger) {
        this.settings = settings;
        this.rb = rb;
        this.registerDb = registerDb;
        this.logger = logger;
    }

    public Void call() {
        B1 b1 = new B1(this.settings, this.logger);
        this.registerDb.deleteProducts();
        do {
            Integer n = this.requestCount;
            this.requestCount = this.requestCount + 1;
            B1ProductListResponse response = b1.fetchCashRegisterProducts(this.pageId);
            this.processResponse(response);
        } while (this.pageId > 0 && this.requestCount < 1000);
        return null;
    }

    private void processResponse(B1ProductListResponse response) {
        if (response.code >= 300) {
            this.logger.error(response.message, "b1.response");
            this.pageId = 0;
        } else {
            for (Product product : response.data) {
                this.registerDb.upsertProduct(product);
            }
            Integer n = this.pageId;
            this.pageId = this.pageId + 1;
            if (this.pageId > response.pages) {
                this.pageId = 0;
            }
        }
    }
}

