/*
 * Decompiled with CFR 0.152.
 */
package lt.b1.cash.register.syncer.task;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import lt.b1.cash.register.syncer.component.RegisterDB;
import lt.b1.cash.register.syncer.logger.Logger;
import lt.b1.cash.register.syncer.model.Sale;

public class RegisterSaleSyncTask
extends Task<String> {
    private final RegisterDB registerDb;
    private final ObservableList<Sale> saleData;
    private String latestSyncSaleDateTime;
    private List<Sale> list;
    private final Logger logger;

    public RegisterSaleSyncTask(ObservableList<Sale> saleData, RegisterDB registerDb, String latestSyncSaleDateTime, Logger logger) {
        this.saleData = saleData;
        this.registerDb = registerDb;
        this.latestSyncSaleDateTime = latestSyncSaleDateTime;
        this.logger = logger;
    }

    @Override
    public String call() {
        this.list = this.registerDb.getSales(LocalDateTime.parse(this.latestSyncSaleDateTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        for (Sale sale : this.list) {
            this.latestSyncSaleDateTime = sale.getDateTime();
        }
        Platform.runLater(() -> {
            for (Sale sale : this.list) {
                if (this.saleData.contains(sale)) continue;
                this.saleData.add(sale);
            }
        });
        return this.latestSyncSaleDateTime;
    }
}

