/*
 * Decompiled with CFR 0.152.
 */
package lt.b1.cash.register.syncer.view;

import java.io.IOException;
import java.util.Properties;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.MenuItem;
import lt.b1.cash.register.syncer.App;

public class RootLayoutController {
    @FXML
    private MenuItem settingsMenuItem;
    @FXML
    private MenuItem resetSettingsMenuItem;
    @FXML
    private MenuItem startMonitorMenuItem;
    @FXML
    private MenuItem stopMonitorMenuItem;
    @FXML
    private MenuItem syncProductsMenuItem;
    @FXML
    private MenuItem deleteProductsMenuItem;
    private App app;

    public void setMainApp(App mainApp) {
        this.app = mainApp;
        this.settingsMenuItem.disableProperty().bind(this.app.monitor);
        this.resetSettingsMenuItem.disableProperty().bind(this.app.monitor);
        this.startMonitorMenuItem.disableProperty().bind(this.app.monitor);
        this.stopMonitorMenuItem.disableProperty().bind(this.app.monitor.not());
        this.syncProductsMenuItem.disableProperty().bind(this.app.connectedToRegister.not());
        this.deleteProductsMenuItem.disableProperty().bind(this.app.connectedToRegister.not());
    }

    @FXML
    private void handleEditSettings() {
        this.app.showSettingsDialog();
    }

    @FXML
    private void handleResetSettings() {
        this.app.resetSettings();
    }

    @FXML
    private void handleExit() {
        System.exit(0);
    }

    @FXML
    private void handleStartMonitor() {
        this.app.startRegisterMonitor();
    }

    @FXML
    private void handleStopMonitor() {
        this.app.stopRegisterMonitor();
    }

    @FXML
    private void handleSyncProducts() {
        this.app.syncProducts();
    }

    @FXML
    private void handleDeleteProducts() {
        this.app.deleteProducts();
    }

    @FXML
    private void handleAbout() throws IOException {
        Properties properties = new Properties();
        properties.load(this.getClass().getResourceAsStream("/main.properties"));
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle(this.app.getResourceBundle().getString("title"));
        alert.setHeaderText(null);
        alert.setContentText(this.app.getResourceBundle().getString("author") + "Serj Ivanov <inphekd@gmail.com>\n" + this.app.getResourceBundle().getString("appVersion") + properties.getProperty("version") + "\n" + this.app.getResourceBundle().getString("libraryVersion") + "2.0.10\n" + this.app.getResourceBundle().getString("website") + "https://www.b1.lt/");
        alert.showAndWait();
    }
}

