/*
 * Decompiled with CFR 0.152.
 */
package lt.b1.cash.register.syncer.view;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.time.LocalDate;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.ToggleButton;
import javafx.stage.FileChooser;
import lt.b1.cash.register.syncer.App;
import lt.b1.cash.register.syncer.logger.LogRecord;
import lt.b1.cash.register.syncer.logger.LogView;
import lt.b1.cash.register.syncer.logger.Logger;
import lt.b1.cash.register.syncer.model.Sale;

public class SaleOverviewController {
    @FXML
    private Button clearConsoleButton;
    @FXML
    private Button saveConsoleButton;
    @FXML
    private ToggleButton followToggleButton;
    @FXML
    private ListView<LogRecord> consoleListView;
    @FXML
    private TableView<Sale> saleTable;
    @FXML
    private TableColumn<Sale, LocalDate> receiptDateColumn;
    @FXML
    private TableColumn<Sale, Number> receiptIdColumn;
    @FXML
    private TableColumn<Sale, String> receiptNumberColumn;
    @FXML
    private TableColumn<Sale, String> customReceiptNumberColumn;
    @FXML
    private TableColumn<Sale, Number> paidWithMoneyColumn;
    @FXML
    private TableColumn<Sale, Number> paidWithOtherColumn;
    @FXML
    private TableColumn<Sale, Number> paidWithCardColumn;
    @FXML
    private TableColumn<Sale, Number> totalColumn;
    @FXML
    private TableColumn<Sale, Number> vatColumn;
    @FXML
    private TableColumn<Sale, Number> discountColumn;
    @FXML
    private TableColumn<Sale, String> loyaltyCardNumberColumn;
    @FXML
    private TableColumn<Sale, String> cashRegisterNumberColumn;
    @FXML
    private TableColumn<Sale, String> cashierFullNameColumn;
    private App app;
    private Logger logger;

    @FXML
    private void initialize() {
        this.followToggleButton.setSelected(true);
        this.receiptDateColumn.setCellValueFactory(cellData -> ((Sale)cellData.getValue()).receiptDateProperty());
        this.receiptIdColumn.setCellValueFactory(cellData -> ((Sale)cellData.getValue()).receiptIdProperty());
        this.receiptNumberColumn.setCellValueFactory(cellData -> ((Sale)cellData.getValue()).receiptNumberProperty());
        this.customReceiptNumberColumn.setCellValueFactory(cellData -> ((Sale)cellData.getValue()).customReceiptNumberProperty());
        this.paidWithMoneyColumn.setCellValueFactory(cellData -> ((Sale)cellData.getValue()).paidWithMoneyProperty());
        this.paidWithOtherColumn.setCellValueFactory(cellData -> ((Sale)cellData.getValue()).paidWithOtherProperty());
        this.paidWithCardColumn.setCellValueFactory(cellData -> ((Sale)cellData.getValue()).paidWithCardProperty());
        this.totalColumn.setCellValueFactory(cellData -> ((Sale)cellData.getValue()).totalProperty());
        this.vatColumn.setCellValueFactory(cellData -> ((Sale)cellData.getValue()).vatProperty());
        this.discountColumn.setCellValueFactory(cellData -> ((Sale)cellData.getValue()).discountProperty());
        this.loyaltyCardNumberColumn.setCellValueFactory(cellData -> ((Sale)cellData.getValue()).loyaltyCardNumberProperty());
        this.cashRegisterNumberColumn.setCellValueFactory(cellData -> ((Sale)cellData.getValue()).cashRegisterNumberProperty());
        this.cashierFullNameColumn.setCellValueFactory(cellData -> ((Sale)cellData.getValue()).cashierFullNameProperty());
    }

    public void setMainApp(App mainApp) {
        this.app = mainApp;
        this.logger = mainApp.getLogger();
        LogView logView = new LogView(this.logger, this.consoleListView);
        logView.followProperty().bind(this.followToggleButton.selectedProperty());
        this.saleTable.setItems(this.app.getSaleData());
    }

    @FXML
    private void handleClearConsole() {
        this.consoleListView.getItems().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    private void handleSaveConsole() {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("LOG files (*.log)", "*.log");
        fileChooser.getExtensionFilters().add(extFilter);
        File file = fileChooser.showSaveDialog(this.app.getPrimaryStage());
        if (file != null) {
            if (!file.getPath().endsWith(".log")) {
                file = new File(file.getPath() + ".log");
            }
            Writer writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(file));
                for (LogRecord item : this.consoleListView.getItems()) {
                    writer.write(item.toString() + "\n");
                }
            }
            catch (Exception ex) {
                this.logger.error(ex.getMessage(), ex.getStackTrace());
            }
            finally {
                try {
                    writer.flush();
                    writer.close();
                }
                catch (IOException ex) {
                    this.logger.error(ex.getMessage(), ex.getStackTrace());
                }
            }
        }
    }

    @FXML
    private void handleToggleFollow() {
    }
}

