/*
 * Decompiled with CFR 0.152.
 */
package lt.b1.cash.register.syncer.view;

import java.util.ResourceBundle;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import lt.b1.cash.register.syncer.App;
import lt.b1.cash.register.syncer.logger.Logger;
import lt.b1.cash.register.syncer.model.Settings;
import lt.b1.cash.register.syncer.model.SupportedLanguage;
import lt.b1.cash.register.syncer.model.SyncInterval;
import lt.b1.cash.register.syncer.model.VatMap;
import lt.b1.cash.register.syncer.task.TestB1ConnectionTask;
import lt.b1.cash.register.syncer.task.TestRegisterConnectionTask;

public class SettingsDialogController {
    @FXML
    private ChoiceBox<SupportedLanguage> languageChoiceBox;
    @FXML
    private TextField b1AddressField;
    @FXML
    private TextField b1ApiKeyField;
    @FXML
    private TextField b1PrivateKeyField;
    @FXML
    private TextField registerDbAddressField;
    @FXML
    private TextField registerDbPortField;
    @FXML
    private TextField registerDbNameField;
    @FXML
    private TextField registerDbUserField;
    @FXML
    private TextField registerDbPasswordField;
    @FXML
    private CheckBox syncBeforeCloseField;
    @FXML
    private CheckBox debugField;
    @FXML
    private TextField b1SyncIntervalField;
    @FXML
    private TextField registerSaleSyncIntervalField;
    @FXML
    private ChoiceBox<SyncInterval> registerProductSyncIntervalChoiceBox;
    @FXML
    private TextField registerProductSyncWithAttributesField;
    @FXML
    private Button testB1ConnectionBtn;
    @FXML
    private Button testRegisterConnectionBtn;
    @FXML
    private ProgressIndicator testRegisterConnectionProgressIndicator;
    @FXML
    private ProgressIndicator testB1ConnectionProgressIndicator;
    @FXML
    private Hyperlink documentationHyperlink;
    @FXML
    private ChoiceBox<VatMap> registerVat21MapChoiceBox;
    @FXML
    private ChoiceBox<VatMap> registerVat9MapChoiceBox;
    @FXML
    private ChoiceBox<VatMap> registerVat5MapChoiceBox;
    @FXML
    private ChoiceBox<VatMap> registerVat0MapChoiceBox;
    private ResourceBundle resource;
    private Stage dialogStage;
    private App app;
    private Logger logger;
    private Settings settings;
    private boolean saveClicked = false;
    private BooleanProperty testingB1Connection = new SimpleBooleanProperty(false);
    private BooleanProperty testingRegisterConnection = new SimpleBooleanProperty(false);
    private final ObservableList<SupportedLanguage> supportedLanguages = FXCollections.observableArrayList(new SupportedLanguage("lt", "LT"), new SupportedLanguage("en", "EN"));
    private final ObservableList<SyncInterval> registerProductSyncIntervalData = FXCollections.observableArrayList(new SyncInterval(43200, "12"), new SyncInterval(86400, "24"));
    private final ObservableList<VatMap> registerVatMapData = FXCollections.observableArrayList(new VatMap(1, "1"), new VatMap(2, "2"), new VatMap(3, "3"), new VatMap(4, "4"), new VatMap(5, "5"), new VatMap(6, "6"));
    private final String documentationUrl = "https://www.b1.lt/doc/api";

    @FXML
    private void initialize() {
        this.languageChoiceBox.setItems(this.supportedLanguages);
        this.registerProductSyncIntervalChoiceBox.setItems(this.registerProductSyncIntervalData);
        this.testB1ConnectionBtn.disableProperty().bind(this.testingB1Connection);
        this.testB1ConnectionProgressIndicator.visibleProperty().bind(this.testingB1Connection);
        this.testRegisterConnectionBtn.disableProperty().bind(this.testingRegisterConnection);
        this.testRegisterConnectionProgressIndicator.visibleProperty().bind(this.testingRegisterConnection);
        this.registerVat21MapChoiceBox.setItems(this.registerVatMapData);
        this.registerVat9MapChoiceBox.setItems(this.registerVatMapData);
        this.registerVat5MapChoiceBox.setItems(this.registerVatMapData);
        this.registerVat0MapChoiceBox.setItems(this.registerVatMapData);
    }

    public void setMainApp(App mainApp) {
        this.app = mainApp;
        this.logger = this.app.getLogger();
    }

    public void setDialogStage(Stage dialogStage) {
        this.dialogStage = dialogStage;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
        for (SupportedLanguage supportedLanguage : this.supportedLanguages) {
            if (!supportedLanguage.getValue().equals(settings.getLanguage())) continue;
            this.languageChoiceBox.setValue(supportedLanguage);
        }
        this.b1AddressField.setText(settings.getB1Address());
        this.b1ApiKeyField.setText(settings.getB1ApiKey());
        this.b1PrivateKeyField.setText(settings.getB1PrivateKey());
        this.registerDbAddressField.setText(settings.getRegisterDbAddress());
        this.registerDbPortField.setText(Integer.toString(settings.getRegisterDbPort()));
        this.registerDbNameField.setText(settings.getRegisterDbName());
        this.registerDbUserField.setText(settings.getRegisterDbUser());
        this.registerDbPasswordField.setText(settings.getRegisterDbPassword());
        this.registerProductSyncWithAttributesField.setText(settings.getRegisterProductSyncWithAttributes());
        this.syncBeforeCloseField.setSelected(settings.getSyncBeforeClose());
        this.debugField.setSelected(settings.getDebug());
        this.b1SyncIntervalField.setText(Integer.toString(settings.getB1SyncInterval()));
        this.registerSaleSyncIntervalField.setText(Integer.toString(settings.getRegisterSaleSyncInterval()));
        for (SyncInterval syncInterval : this.registerProductSyncIntervalData) {
            if (!syncInterval.getInterval().equals(settings.getRegisterProductSyncInterval())) continue;
            this.registerProductSyncIntervalChoiceBox.setValue(syncInterval);
        }
        for (VatMap vatMap : this.registerVatMapData) {
            if (vatMap.getValue().equals(settings.getRegisterVat21Map())) {
                this.registerVat21MapChoiceBox.setValue(vatMap);
            }
            if (vatMap.getValue().equals(settings.getRegisterVat9Map())) {
                this.registerVat9MapChoiceBox.setValue(vatMap);
            }
            if (vatMap.getValue().equals(settings.getRegisterVat5Map())) {
                this.registerVat5MapChoiceBox.setValue(vatMap);
            }
            if (!vatMap.getValue().equals(settings.getRegisterVat0Map())) continue;
            this.registerVat0MapChoiceBox.setValue(vatMap);
        }
    }

    public boolean isSaveClicked() {
        return this.saveClicked;
    }

    @FXML
    private void handleSave() {
        if (this.isInputValid()) {
            this.settings.setLanguage(this.languageChoiceBox.getValue().getValue());
            this.settings.setB1Address(this.b1AddressField.getText());
            this.settings.setB1ApiKey(this.b1ApiKeyField.getText());
            this.settings.setB1PrivateKey(this.b1PrivateKeyField.getText());
            this.settings.setRegisterDbAddress(this.registerDbAddressField.getText());
            this.settings.setRegisterDbPort(Integer.parseInt(this.registerDbPortField.getText()));
            this.settings.setRegisterDbName(this.registerDbNameField.getText());
            this.settings.setRegisterDbUser(this.registerDbUserField.getText());
            this.settings.setRegisterDbPassword(this.registerDbPasswordField.getText());
            this.settings.setSyncBeforeClose(this.syncBeforeCloseField.isSelected());
            this.settings.setDebug(this.debugField.isSelected());
            this.settings.setB1SyncInterval(Integer.parseInt(this.b1SyncIntervalField.getText()));
            this.settings.setRegisterSaleSyncInterval(Integer.parseInt(this.registerSaleSyncIntervalField.getText()));
            this.settings.setRegisterProductSyncWithAttributes(this.registerProductSyncWithAttributesField.getText());
            this.settings.setRegisterProductSyncInterval(this.registerProductSyncIntervalChoiceBox.getValue().getInterval());
            this.settings.setConnectOnRun(true);
            this.settings.setRegisterVat21Map(this.registerVat21MapChoiceBox.getValue().getValue());
            this.settings.setRegisterVat9Map(this.registerVat9MapChoiceBox.getValue().getValue());
            this.settings.setRegisterVat5Map(this.registerVat5MapChoiceBox.getValue().getValue());
            this.settings.setRegisterVat0Map(this.registerVat0MapChoiceBox.getValue().getValue());
            this.saveClicked = true;
            this.app.saveSettingsToFile();
            this.dialogStage.close();
        }
    }

    @FXML
    private void handleTestB1Connection() {
        TestB1ConnectionTask task = new TestB1ConnectionTask(this.b1ApiKeyField.getText(), this.b1PrivateKeyField.getText(), this.b1AddressField.getText(), this.app, this.logger);
        new Thread(task).start();
        task.stateProperty().addListener((observableValue, oldState, newState) -> {
            if (newState.equals((Object)Worker.State.RUNNING)) {
                this.testingB1Connection.set(true);
                this.logger.debug(this.app.getResourceBundle().getString("testingB1Connection"));
            } else if (newState.equals((Object)Worker.State.SUCCEEDED)) {
                this.testingB1Connection.set(false);
                this.logger.debug(this.app.getResourceBundle().getString("testConnectionToB1SuccessfullyPassed"));
                Alert alert = new Alert(Alert.AlertType.INFORMATION);
                alert.setTitle(this.app.getResourceBundle().getString("information"));
                alert.setHeaderText(null);
                alert.setContentText(this.app.getResourceBundle().getString("testConnectionToB1SuccessfullyPassed"));
                alert.showAndWait();
            } else if (newState.equals((Object)Worker.State.FAILED)) {
                this.testingB1Connection.set(false);
                Throwable exception = task.getException();
                this.logger.debug(this.app.getResourceBundle().getString("testConnectionToB1Failed.reason") + exception.getMessage());
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle(this.app.getResourceBundle().getString("error"));
                alert.setHeaderText(null);
                alert.setContentText(exception.getMessage());
                alert.showAndWait();
            }
        });
    }

    @FXML
    private void handleTestRegisterConnection() {
        TestRegisterConnectionTask task = new TestRegisterConnectionTask(this.registerDbAddressField.getText(), this.registerDbPortField.getText(), this.registerDbNameField.getText(), this.registerDbUserField.getText(), this.registerDbPasswordField.getText());
        new Thread(task).start();
        task.stateProperty().addListener((observableValue, oldState, newState) -> {
            if (newState.equals((Object)Worker.State.RUNNING)) {
                this.testingRegisterConnection.set(true);
                this.logger.debug(this.app.getResourceBundle().getString("testingRegisterConnection"));
            } else if (newState.equals((Object)Worker.State.SUCCEEDED)) {
                this.testingRegisterConnection.set(false);
                this.logger.debug(this.app.getResourceBundle().getString("testConnectionToRegisterSuccessfullyPassed"));
                Alert alert = new Alert(Alert.AlertType.INFORMATION);
                alert.setTitle(this.app.getResourceBundle().getString("information"));
                alert.setHeaderText(null);
                alert.setContentText(this.app.getResourceBundle().getString("testConnectionToRegisterSuccessfullyPassed"));
                alert.showAndWait();
            } else if (newState.equals((Object)Worker.State.FAILED)) {
                this.testingRegisterConnection.set(false);
                Throwable exception = task.getException();
                this.logger.debug(this.app.getResourceBundle().getString("testConnectionToRegisterFailed.reason") + exception.getMessage());
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle(this.app.getResourceBundle().getString("error"));
                alert.setHeaderText(null);
                alert.setContentText(exception.getMessage());
                alert.showAndWait();
            }
        });
    }

    @FXML
    private void handleCancel() {
        this.dialogStage.close();
    }

    @FXML
    private void handleDocumentationLinkClick() {
        this.logger.info("Documentation: https://www.b1.lt/doc/api");
    }

    private boolean isInputValid() {
        Object errorMessage = "";
        if (this.b1AddressField.getText() == null || this.b1AddressField.getText().length() == 0) {
            errorMessage = (String)errorMessage + "No valid B1 address specified.\n";
        }
        if (this.b1ApiKeyField.getText() == null || this.b1ApiKeyField.getText().length() == 0) {
            errorMessage = (String)errorMessage + "No valid B1 API key specified.\n";
        }
        if (this.b1PrivateKeyField.getText() == null || this.b1PrivateKeyField.getText().length() == 0) {
            errorMessage = (String)errorMessage + "No valid B1 private key specified.\n";
        }
        if (this.registerDbAddressField.getText() == null || this.registerDbAddressField.getText().length() == 0) {
            errorMessage = (String)errorMessage + "No valid register DB address specified.\n";
        }
        if (this.registerDbPortField.getText() == null || this.registerDbPortField.getText().length() == 0) {
            errorMessage = (String)errorMessage + "No valid register DB port specified.\n";
        }
        if (this.registerDbNameField.getText() == null || this.registerDbNameField.getText().length() == 0) {
            errorMessage = (String)errorMessage + "No valid register DB name specified.\n";
        }
        if (this.registerDbUserField.getText() == null || this.registerDbUserField.getText().length() == 0) {
            errorMessage = (String)errorMessage + "No valid register DB user specified.\n";
        }
        if (this.registerDbPasswordField.getText() == null || this.registerDbPasswordField.getText().length() == 0) {
            errorMessage = (String)errorMessage + "No valid register DB password specified.\n";
        }
        if (this.registerSaleSyncIntervalField.getText() == null || this.registerSaleSyncIntervalField.getText().length() == 0) {
            errorMessage = (String)errorMessage + "No valid register sync period specified.\n";
        }
        if (((String)errorMessage).length() == 0) {
            return true;
        }
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.initOwner(this.dialogStage);
        alert.setTitle("Invalid Fields");
        alert.setHeaderText("Please correct invalid fields");
        alert.setContentText((String)errorMessage);
        alert.showAndWait();
        return false;
    }
}

